/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes.compras;

import ec.gob.sri.dimm.api.modelo.validacion.ContextoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.ProveedorContextoValidacion;
import ec.gob.sri.dimm.api.ui.asistentes.AsistenteBase;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.compras.TransaccionCompra;
import ec.gob.sri.dimm.ats.modelo.util.Constantes;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.compras.PaginaComprobanteCompra;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.compras.PaginaFormasDePago;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.compras.PaginaPagoLocal;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.compras.PaginaProveedor;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.compras.PaginaValoresComprobante;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;

public class AsistenteEdicionCompras
extends AsistenteBase
implements INewWizard {
    private PaginaProveedor paginaProveedor;
    private PaginaComprobanteCompra paginaComprobante;
    private PaginaValoresComprobante paginaValores;
    private PaginaPagoLocal paginaPagoLocal;
    private PaginaFormasDePago formasPago;
    private boolean editando;
    private Seccion seccionAEditar;
    private final TransaccionCompra modeloDatos;
    private final Periodo periodo;

    public AsistenteEdicionCompras(TransaccionCompra compra, boolean editando, Seccion seccion, Periodo periodo) {
        this.modeloDatos = compra;
        this.periodo = periodo;
        this.editando = editando;
        this.seccionAEditar = seccion;
        this.modeloDatos.getComprobanteRetencion().setProveedorContextoValidacion(new ProveedorContextoValidacion(){

            public ContextoValidacion getContextoValidacion() {
                ContextoValidacion ctxVal = new ContextoValidacion();
                ctxVal.agregar("FECHA_COMPROBANTE", (Object)AsistenteEdicionCompras.this.modeloDatos.getComprobanteCompra().getFechaEmision());
                ctxVal.agregar("FECHA_REGISTRO", (Object)AsistenteEdicionCompras.this.modeloDatos.getComprobanteCompra().getFechaRegistro());
                return ctxVal;
            }
        });
    }

    public void addPages() {
        switch (this.seccionAEditar) {
            case PROVEEDOR: {
                this.paginaProveedor = new PaginaProveedor(this.editando, this.periodo);
                this.paginaProveedor.setModeloDatos(this.modeloDatos.getProveedor());
                this.paginaProveedor.inicializarModeloValores();
                this.addPage((IWizardPage)this.paginaProveedor);
                break;
            }
            case COMPROBANTE: {
                this.paginaComprobante = new PaginaComprobanteCompra(this.editando);
                this.paginaComprobante.setModeloDatos(this.modeloDatos);
                this.paginaComprobante.inicializarModeloValores();
                this.addPage((IWizardPage)this.paginaComprobante);
                break;
            }
            case VALORES: {
                this.paginaValores = new PaginaValoresComprobante(this.editando, this.periodo);
                this.paginaValores.setModeloDatos(this.modeloDatos.getComprobanteCompra().getValoresComprovanteVenta());
                this.paginaValores.setPageComplete(false);
                boolean esNotaDebitoOCredito = this.modeloDatos.getComprobanteCompra().getTipoComprobante().equals("04");
                this.formasPago = new PaginaFormasDePago(this.editando, esNotaDebitoOCredito, this.periodo);
                this.formasPago.setModeloDatos(this.modeloDatos.getComprobanteCompra().getValoresComprovanteVenta());
                this.formasPago.inicializarModeloValores();
                this.addPage((IWizardPage)this.paginaValores);
                this.addPage((IWizardPage)this.formasPago);
                break;
            }
            case FORMAS_PAGO: {
                boolean esNotaDebitoCredito = this.modeloDatos.getComprobanteCompra().getTipoComprobante().equals("04");
                this.formasPago = new PaginaFormasDePago(this.editando, esNotaDebitoCredito, this.periodo);
                this.formasPago.setModeloDatos(this.modeloDatos.getComprobanteCompra().getValoresComprovanteVenta());
                this.formasPago.inicializarModeloValores();
                this.addPage((IWizardPage)this.formasPago);
                break;
            }
            case LOCAL: {
                this.paginaPagoLocal = new PaginaPagoLocal(this.editando, this.periodo);
                this.paginaPagoLocal.setModeloDatos(this.modeloDatos);
                this.paginaPagoLocal.inicializarModeloValores();
                this.addPage((IWizardPage)this.paginaPagoLocal);
                break;
            }
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage instanceof PaginaValoresComprobante && (this.modeloDatos.getComprobanteCompra().getValoresComprovanteVenta().getTotalSumaFormasPago().compareTo(Constantes.MIL) < 0 || !((Iva)this.modeloDatos.getPropietario()).esAnexoEnRangoDe2013A2014())) {
            return null;
        }
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage instanceof PaginaValoresComprobante && this.modeloDatos.getComprobanteCompra().getValoresComprovanteVenta().getTotalSumaFormasPago().compareTo(Constantes.MIL) < 0 && ((Iva)this.modeloDatos.getPropietario()).esAnexoEnRangoDe2013A2014() && this.mostrarPregunta("La sumatoria de las bases imponibles es menor a 1000\n En caso de tener formas de pago, estas ser\u00e1n eliminidas\n\u00bfDesea continuar?")) {
            this.modeloDatos.getComprobanteCompra().getValoresComprovanteVenta().getFormasPago().clear();
        }
        return true;
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage instanceof PaginaValoresComprobante && (this.modeloDatos.getComprobanteCompra().getValoresComprovanteVenta().getTotalSumaFormasPago().compareTo(Constantes.MIL) < 0 || !((Iva)this.modeloDatos.getPropietario()).esAnexoEnRangoDe2013A2014())) {
            return currentPage.isPageComplete();
        }
        return super.canFinish();
    }

    public static enum Seccion {
        PROVEEDOR,
        COMPROBANTE,
        VALORES,
        LOCAL,
        FORMAS_PAGO;

    }
}

